<?php

namespace App\Controllers;

class Admin extends BaseController
{
    
     
	public function __construct()
    {
			
       $this->AdminModel = new \App\Models\AdminModel();
    } 

    public function dashboard()
    {
        
        $data['active'] = "dashboard";
        $data['dashboard_data'] = $this->AdminModel->dashboard_data();
        return view('header', $data) . view('dashboard', $data) . view('footer', $data);
    }

    public function view_centers()
    {
        $data['active'] = "users";
        $data['centers_list'] = $this->AdminModel->view_center();
        return view('header', $data) . view('all_centers', $data) . view('footer', $data);
    }

    public function delete_user($id)
    {
        $data['active'] = "users";
        $this->AdminModel->delete_user($id);
        return redirect()->to(base_url('admin/view_centers'));
    }

    public function edit_user($id)
    {
        $data['active'] = "users";
        $data['center_details'] = $this->AdminModel->get_center($id);
        return view('header', $data) . view('edit_centers', $data) . view('footer', $data);
    }

    public function view_center_details($id)
    {
        $data['active'] = "users";
        $data['center_details'] = $this->AdminModel->get_center($id);
        return view('header', $data) . view('view_center_details', $data) . view('footer', $data);
    }

    public function add_center()
    {
        $data['active'] = "users";
        return view('header', $data) . view('add_centers', $data) . view('footer', $data);
    }

    public function process_add_center()
    {
        if (session()->get('user_type')) {
            $config = [
                ['field' => 'first_name', 'label' => 'First Name', 'rules' => 'required'],
                ['field' => 'mobile',     'label' => 'Mobile No',  'rules' => 'required|min_length[10]|max_length[10]'],
                ['field' => 'email',      'label' => 'Email ID',   'rules' => 'trim|required|valid_email'],
                ['field' => 'password',   'label' => 'Password',   'rules' => 'trim|required'],
                ['field' => 'user_name',  'label' => 'User Name',  'rules' => 'required|check_unique_user'],
                ['field' => 'status',     'label' => 'Status',     'rules' => 'required'],
            ];

            if (!$this->validate(array_column($config, 'rules', 'field'))) {
                $data['active'] = "users";
                return view('header', $data) . view('add_centers', $data) . view('footer', $data);
            } else {
                $result = $this->AdminModel->add_center();
                return redirect()->to(base_url('admin/view_centers'));
            }
        } else {
            return redirect()->to(base_url('login/index'));
        }
    }

    public function check_unique_user($user_name)
    {
        $result = $this->AdminModel->get_user_by_user_name($user_name);
        if (empty($result) === FALSE) {
            $this->validator->setError('user_name', 'This {field} is already exist in our database.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function process_edit_center($id)
    {
        if (session()->get('user_type')) {
            $config = [
                ['field' => 'first_name', 'label' => 'First Name', 'rules' => 'required'],
                ['field' => 'mobile',     'label' => 'Mobile No',  'rules' => 'required|min_length[10]|max_length[10]'],
                ['field' => 'email',      'label' => 'Email ID',   'rules' => 'trim|required|valid_email'],
                ['field' => 'status',     'label' => 'Status',     'rules' => 'required'],
            ];

            if (!$this->validate(array_column($config, 'rules', 'field'))) {
                $data['active'] = "users";
                $data['center_details'] = $this->AdminModel->get_center($id);
                return view('header', $data) . view('edit_centers', $data) . view('footer', $data);
            } else {
                $result = $this->AdminModel->update_center($id);
                return redirect()->to(base_url('admin/view_centers'));
            }
        } else {
            return redirect()->to(base_url('login/index'));
        }
    }

    public function center_status($id, $status)
    {
        $data['active'] = "users";
        $status = $this->AdminModel->change_center_status($id, $status);
        if ($status) {
            return redirect()->to(base_url('admin/view_centers'));
        }
    }

    public function add_course()
    {
        $data['active'] = "courses";
        return view('header', $data) . view('add_course', $data) . view('footer', $data);
    }

    public function process_add_course()
    {
        $config = [
            ['field' => 'cousre_name', 'label' => 'Cousre Name',    'rules' => 'required'],
            ['field' => 'course_year', 'label' => 'Course Semester', 'rules' => 'required'],
            ['field' => 'status',      'label' => 'Status',          'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "courses";
            return view('header', $data) . view('add_course', $data) . view('footer', $data);
        } else {
            $result = $this->AdminModel->add_courses();
            return redirect()->to(base_url('admin/view_courses'));
        }
    }

    public function view_courses()
    {
        $data['active'] = "courses";
        $data['course_list'] = $this->AdminModel->all_course_list();
        return view('header', $data) . view('all_courses', $data) . view('footer', $data);
    }

    public function course_status($id, $status)
    {
        $data['active'] = "courses";
        $status = $this->AdminModel->change_course_status($id, $status);
        if ($status) {
            return redirect()->to(base_url('admin/view_courses'));
        }
    }

    public function delete_course($id)
    {
        $data['active'] = "courses";
        $this->AdminModel->delete_course($id);
        return redirect()->to(base_url('admin/view_courses'));
    }

    public function edit_course($id)
    {
        $data['active'] = "courses";
        $data['course_details'] = $this->AdminModel->get_course_by_id($id);
        return view('header', $data) . view('edit_course', $data) . view('footer', $data);
    }

    public function process_edit_course($id)
    {
        $config = [
            ['field' => 'cousre_name', 'label' => 'Cousre Name',    'rules' => 'required'],
            ['field' => 'course_year', 'label' => 'Course Semester', 'rules' => 'required'],
            ['field' => 'status',      'label' => 'Status',          'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "courses";
            $data['course_details'] = $this->AdminModel->get_course_by_id($id);
            return view('header', $data) . view('edit_course', $data) . view('footer', $data);
        } else {
            $result = $this->AdminModel->update_course($id);
            return redirect()->to(base_url('admin/view_courses'));
        }
    }

    public function add_sub_course()
    {
        $data['active'] = "sub_course";
        return view('header', $data) . view('add_sub_course', $data) . view('footer', $data);
    }

    public function process_add_sub_course()
    {
        $config = [
            ['field' => 'course_id',       'label' => 'Cousre',         'rules' => 'required'],
            ['field' => 'cousre_name',     'label' => 'Sub Course Name', 'rules' => 'required'],
            ['field' => 'fee',             'label' => 'Fee',             'rules' => 'required'],
            ['field' => 'exam_fee',        'label' => 'Exam Fee',        'rules' => 'required'],
            ['field' => 'credit_transfer', 'label' => 'Credit Transfer', 'rules' => 'required'],
            ['field' => 'lateral_fees',    'label' => 'Lateral Fees',    'rules' => 'required'],
            ['field' => 'status',          'label' => 'Status',          'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "sub_course";
            return view('header', $data) . view('add_sub_course', $data) . view('footer', $data);
        } else {
            $result = $this->AdminModel->add_sub_courses();
            return redirect()->to(base_url('admin/view_sub_courses'));
        }
    }

    public function view_sub_courses()
    {
        $data['active'] = "sub_course";
        $data['sub_course_list'] = $this->AdminModel->sub_course_list();
        return view('header', $data) . view('all_sub_courses', $data) . view('footer', $data);
    }

    public function sub_course_status($id, $status)
    {
        $data['active'] = "sub_course";
        $status = $this->AdminModel->change_sub_course_status($id, $status);
        if ($status) {
            return redirect()->to(base_url('admin/view_sub_courses'));
        }
    }

    public function delete_sub_course($id)
    {
        $data['active'] = "sub_course";
        $this->AdminModel->delete_sub_course($id);
        return redirect()->to(base_url('admin/view_sub_courses'));
    }

    public function edit_sub_course($id)
    {
        $data['active'] = "sub_course";
        $data['sub_course_details'] = $this->AdminModel->get_sub_course_by_id($id);
        return view('header', $data) . view('edit_sub_course', $data) . view('footer', $data);
    }

    public function process_edit_sub_course($id)
    {
        $config = [
            ['field' => 'course_id',       'label' => 'Cousre',         'rules' => 'required'],
            ['field' => 'cousre_name',     'label' => 'Sub Course Name', 'rules' => 'required'],
            ['field' => 'fee',             'label' => 'Fee',             'rules' => 'required'],
            ['field' => 'exam_fee',        'label' => 'Exam Fee',        'rules' => 'required'],
            ['field' => 'credit_transfer', 'label' => 'Credit Transfer', 'rules' => 'required'],
            ['field' => 'lateral_fees',    'label' => 'Lateral Fees',    'rules' => 'required'],
            ['field' => 'status',          'label' => 'Status',          'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "sub_course";
            $data['sub_course_details'] = $this->AdminModel->get_sub_course_by_id($id);
            return view('header', $data) . view('edit_sub_course', $data) . view('footer', $data);
        } else {
            $result = $this->AdminModel->update_sub_course($id);
            return redirect()->to(base_url('admin/view_sub_courses'));
        }
    }

    public function pending_student_fees()
    {
        $data['active'] = "bill";
        $data['student'] = "pending";
        $data['student_details'] = $this->AdminModel->get_student_details(CURRENT_SESSION, 'pending');
        return view('header', $data) . view('all_student_fees', $data) . view('footer', $data);
    }

    public function enrolled_student_fees()
    {
        $data['active'] = "bill";
        $data['student'] = "enrolled";
        $data['student_details'] = $this->AdminModel->get_student_details(CURRENT_SESSION, 'enrolled');
        return view('header', $data) . view('all_student_fees', $data) . view('footer', $data);
    }

    public function total_student_fees()
    {
        $data['active'] = "bill";
        $data['student'] = "total";
        $data['student_details'] = $this->AdminModel->get_student_details(CURRENT_SESSION, 'total');
        return view('header', $data) . view('all_student_fees', $data) . view('footer', $data);
    }

    public function view_student_list()
    {
        $data['active'] = "show_student";
        $data['student_details'] = $this->AdminModel->student_details();
        return view('header', $data) . view('all_student_list', $data) . view('footer', $data);
    }

    public function add_student()
    {
        $data['active'] = "student";
        return view('header', $data) . view('add_student', $data) . view('footer', $data);
    }

    public function process_add_student()
    {
        $config = [
            ['field' => 'admission_type',          'label' => 'Admission Type',        'rules' => 'required'],
            ['field' => 'admission_session',        'label' => 'Admission Session',     'rules' => 'required'],
            ['field' => 'course_id',               'label' => 'Course ',               'rules' => 'required'],
            ['field' => 'sub_course_id',           'label' => 'Course ',               'rules' => 'required'],
            ['field' => 'year',                    'label' => 'Year ',                 'rules' => 'required'],
            ['field' => 'student_name',            'label' => 'Student Name ',         'rules' => 'required'],
            ['field' => 'father_name',             'label' => 'Father Name ',          'rules' => 'required'],
            ['field' => 'mother_name',             'label' => 'Mother Name ',          'rules' => 'required'],
            ['field' => 'gender',                  'label' => 'Gender',                'rules' => 'required'],
            ['field' => 'dob',                     'label' => 'DOB',                   'rules' => 'required|callback_date_valid'],
            ['field' => 'address',                 'label' => 'Address',               'rules' => 'required'],
            ['field' => 'state',                   'label' => 'State',                 'rules' => 'required'],
            ['field' => 'city',                    'label' => 'City',                  'rules' => 'required'],
            ['field' => 'pin_code',                'label' => 'Pin Code',              'rules' => 'required|min_length[6]|max_length[6]'],
            ['field' => 'area',                    'label' => 'Area',                  'rules' => 'required'],
            ['field' => 'mobile',                  'label' => 'Mobile No',             'rules' => 'required|min_length[10]|max_length[10]'],
            ['field' => 'email_id',                'label' => 'Email ID',              'rules' => 'trim|required|valid_email'],
            ['field' => 'nationality',             'label' => 'Nationality',           'rules' => 'required'],
            ['field' => 'cast_category',           'label' => 'Cast Category',         'rules' => 'required'],
            ['field' => 'employment_status',       'label' => 'Employment Status',     'rules' => 'required'],
            ['field' => 'image',                   'label' => 'Photo',                 'rules' => 'trim|callback_image_check'],
            ['field' => 'year10',                  'label' => 'Year',                  'rules' => 'required'],
            ['field' => 'subject10',               'label' => 'Subject',               'rules' => 'required'],
            ['field' => 'board10',                 'label' => 'Board',                 'rules' => 'required'],
            ['field' => 'quanlification_status10', 'label' => 'Quanlification Status', 'rules' => 'required'],
            ['field' => 'year12',                  'label' => 'Year',                  'rules' => 'required'],
            ['field' => 'subject12',               'label' => 'Subject',               'rules' => 'required'],
            ['field' => 'board12',                 'label' => 'Board',                 'rules' => 'required'],
            ['field' => 'quanlification_status12', 'label' => 'Quanlification Status', 'rules' => 'required'],
            ['field' => 'adhar_card',              'label' => 'Adhar Card',            'rules' => 'required|numeric|min_length[12]|max_length[12]'],
            ['field' => 'status',                  'label' => 'Status',                'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "student";
            return view('header', $data) . view('add_student', $data) . view('footer', $data);
        } else {
            $inserted_id = $this->AdminModel->add_student();
            session()->setFlashdata('success_message', 'Application has been locked Successfully!!');
            session()->setFlashdata('student_id', $inserted_id);
            return redirect()->to(base_url('admin/lock_details/' . $inserted_id));
        }
    }

    public function date_valid($date)
    {
        if (date('d-m-Y', strtotime($date)) == $date) {
            return true;
        } else {
            $this->validator->setError('dob', 'Please select date dd-mm-yyyy format');
            return false;
        }
    }

    public function image_check()
    {
        $allowed_mime_type_arr = ['image/gif', 'image/jpeg', 'image/pjpeg', 'image/png', 'image/x-png'];
        $file = $this->request->getFile('image');
        $mime = $file ? $file->getMimeType() : '';
        $img_size = $file ? $file->getSize() : 0;

        if (!$file || !$file->getName()) {
            $this->validator->setError('image', 'Photo field is required.');
            return false;
        } elseif (!in_array($mime, $allowed_mime_type_arr)) {
            $this->validator->setError('image', 'Photo Allow file Formats ( jpg, gif, png ).');
            return false;
        } elseif ($img_size > 102400) {
            $this->validator->setError('image', 'Allow Maximum File Size 100KB');
            return false;
        } else {
            return true;
        }
    }

    public function get_subcourse_by_courseid()
    {
        $result = $this->AdminModel->sub_course_by_courseid($this->request->getPost('course_id'));
        if (count($result) > 0) {
            $htmlString = "<option value=''>Select Sub Course</option>";
            foreach ($result as $row) {
                $id = $row['id'];
                $name = $row['name'];
                $htmlString .= "<option value='$id'>$name</option>";
            }
        } else {
            $htmlString = "<option value=''>No Sub Course</option>";
        }
        echo json_encode($htmlString);
    }

    public function get_city_by_state()
    {
        $result = $this->AdminModel->get_city_by_state($this->request->getPost('state'));
        if (count($result) > 0) {
            $htmlString = "<option value=''>Select City</option>";
            foreach ($result as $row) {
                $id = $row['city_id'];
                $name = $row['city_name'];
                $htmlString .= "<option value='$name'>$name</option>";
            }
        } else {
            $htmlString = "<option value=''>No CITY</option>";
        }
        echo json_encode($htmlString);
    }

    public function delete_student($id)
    {
        $data['active'] = "student";
        $result = $this->AdminModel->delete_student($id);
        if ($result) {
            return redirect()->to(base_url('admin/view_student_list'));
        }
    }

    public function print_form($id)
    {
        $result = $this->AdminModel->get_student_by_id($id);
        $data['studentArray'] = $result;
        return view('print_student_form', $data);
    }

    public function print_ack($id)
    {
        $result = $this->AdminModel->get_student_by_id($id);
        $data['studentArray'] = $result;
        return view('print_ack', $data);
    }

    public function edit_student($id)
    {
        $data['active'] = "student";
        $result = $this->AdminModel->get_student_by_id($id);
        $data['studentArray'] = $result;
        return view('header', $data) . view('edit_student', $data) . view('footer', $data);
    }

    public function process_edit_student($id)
    {
        $config = [
            ['field' => 'admission_type',          'label' => 'Admission Type',        'rules' => 'required'],
            ['field' => 'admission_session',        'label' => 'Admission Session',     'rules' => 'required'],
            ['field' => 'course_id',               'label' => 'Course ',               'rules' => 'required'],
            ['field' => 'sub_course_id',           'label' => 'Course ',               'rules' => 'required'],
            ['field' => 'year',                    'label' => 'Year ',                 'rules' => 'required'],
            ['field' => 'student_name',            'label' => 'Student Name ',         'rules' => 'required'],
            ['field' => 'father_name',             'label' => 'Father Name ',          'rules' => 'required'],
            ['field' => 'mother_name',             'label' => 'Mother Name ',          'rules' => 'required'],
            ['field' => 'gender',                  'label' => 'Gender',                'rules' => 'required'],
            ['field' => 'dob',                     'label' => 'DOB',                   'rules' => 'required|callback_date_valid'],
            ['field' => 'address',                 'label' => 'Address',               'rules' => 'required'],
            ['field' => 'state',                   'label' => 'State',                 'rules' => 'required'],
            ['field' => 'city',                    'label' => 'City',                  'rules' => 'required'],
            ['field' => 'pin_code',                'label' => 'Pin Code',              'rules' => 'required|min_length[6]|max_length[6]'],
            ['field' => 'area',                    'label' => 'Area',                  'rules' => 'required'],
            ['field' => 'mobile',                  'label' => 'Mobile No',             'rules' => 'required|min_length[10]|max_length[10]'],
            ['field' => 'email_id',                'label' => 'Email ID',              'rules' => 'trim|required|valid_email'],
            ['field' => 'nationality',             'label' => 'Nationality',           'rules' => 'required'],
            ['field' => 'cast_category',           'label' => 'Cast Category',         'rules' => 'required'],
            ['field' => 'employment_status',       'label' => 'Employment Status',     'rules' => 'required'],
            ['field' => 'year10',                  'label' => 'Year',                  'rules' => 'required'],
            ['field' => 'subject10',               'label' => 'Subject',               'rules' => 'required'],
            ['field' => 'board10',                 'label' => 'Board',                 'rules' => 'required'],
            ['field' => 'quanlification_status10', 'label' => 'Quanlification Status', 'rules' => 'required'],
            ['field' => 'year12',                  'label' => 'Year',                  'rules' => 'required'],
            ['field' => 'subject12',               'label' => 'Subject',               'rules' => 'required'],
            ['field' => 'board12',                 'label' => 'Board',                 'rules' => 'required'],
            ['field' => 'quanlification_status12', 'label' => 'Quanlification Status', 'rules' => 'required'],
            ['field' => 'adhar_card',              'label' => 'Adhar Card',            'rules' => 'required|numeric|min_length[12]|max_length[12]'],
            ['field' => 'status',                  'label' => 'Status',                'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "student";
            $result = $this->AdminModel->get_student_by_id($id);
            $data['studentArray'] = $result;
            return view('header', $data) . view('edit_student', $data) . view('footer', $data);
        } else {
            $result = $this->AdminModel->update_student($id);
            if (isset($_POST['reff_url']) && $_POST['reff_url'] == 'lock_details') {
                session()->setFlashdata('success_message', 'Application has been submited Successfully!!');
                session()->setFlashdata('student_id', $id);
                return redirect()->to(base_url('admin/add_student_success'));
            } else {
                session()->setFlashdata('success_message', 'Student details Has been updated Successfully.');
                return redirect()->to(base_url('admin/add_student_success'));
            }
        }
    }

    public function change_password()
    {
        $config = [
            ['field' => 'old_password',     'label' => 'Old Password',         'rules' => 'required'],
            ['field' => 'new_password',     'label' => 'New Password',         'rules' => 'required'],
            ['field' => 'confirm_password', 'label' => 'Confirm New Password', 'rules' => 'required|matches[new_password]'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            return view('header', $data) . view('change_password', $data) . view('footer', $data);
        } else {
            $center_details = $this->AdminModel->change_password();
            if ($center_details) {
                $data['message'] = 'success';
            } else {
                $data['message'] = 'fail';
            }
            return view('header', $data) . view('change_password', $data) . view('footer', $data);
        }
    }

    public function news()
    {
        $data['active'] = "news";
        $data['news_n_events'] = $this->AdminModel->get_all_news();
        return view('header', $data) . view('all_news', $data) . view('footer', $data);
    }

    public function news_status($id, $status)
    {
        $data['active'] = "news";
        $status = $this->AdminModel->change_news_status($id, $status);
        if ($status) {
            return redirect()->to(base_url('admin/news'));
        }
    }

    public function add_news()
    {
        $data['active'] = "news";
        return view('header', $data) . view('add_news', $data) . view('footer', $data);
    }

    public function process_add_news()
    {
        $config = [
            ['field' => 'news_title',       'label' => 'News Title',       'rules' => 'required'],
            ['field' => 'news_description', 'label' => 'News Description', 'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "news";
            return view('header', $data) . view('add_news', $data) . view('footer', $data);
        } else {
            $data['active'] = "news";
            $result = $this->AdminModel->insert_news();
            if ($result) {
                return redirect()->to(base_url('admin/news'));
            }
        }
    }

    public function edit_news($id)
    {
        $data['active'] = "news";
        $data['get_news'] = $this->AdminModel->get_news_by_id($id);
        return view('header', $data) . view('edit_news', $data) . view('footer', $data);
    }

    public function process_update_news($id)
    {
        $config = [
            ['field' => 'news_title',       'label' => 'News Title',       'rules' => 'required'],
            ['field' => 'news_description', 'label' => 'News Description', 'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "news";
            return view('header', $data) . view('edit_news', $data) . view('footer', $data);
        } else {
            $data['active'] = "news";
            $result = $this->AdminModel->update_news($id);
            if ($result) {
                return redirect()->to(base_url('admin/news'));
            }
        }
    }

    public function view_news($id)
    {
        $data['active'] = "news";
        $data['get_news'] = $this->AdminModel->get_news_by_id($id);
        return view('header', $data) . view('view_news', $data) . view('footer', $data);
    }

    public function change_counselor()
    {
        $data['active'] = "change_counselor";
        return view('header', $data) . view('change_counselor', $data) . view('footer', $data);
    }

    public function process_change_counselor()
    {
        $config = [
            ['field' => 'counselor_feedback', 'label' => 'Request To Change Counselor', 'rules' => 'required'],
        ];

        if (!$this->validate(array_column($config, 'rules', 'field'))) {
            $data['active'] = "change_counselor";
            return view('header', $data) . view('change_counselor', $data) . view('footer', $data);
        } else {
            $data['active'] = "change_counselor";
            $result = $this->AdminModel->insert_counselor_feedback();
            if ($result) {
                return redirect()->to(base_url('admin/view_counselor_feedback'));
            }
        }
    }

    public function view_counselor_feedback()
    {
        $data['active'] = "change_counselor";
        $data['feedback'] = $this->AdminModel->get_counselor_feedback();
        return view('header', $data) . view('all_counselor_feedback', $data) . view('footer', $data);
    }

    public function get_counselor()
    {
        $result = $this->AdminModel->get_counselor_by_name($this->request->getPost('counselor_name'));
        $content = [];
        if (empty($result) === FALSE) {
            $content['email']  = $result[0]['counselor_email'];
            $content['mobile'] = $result[0]['counselor_mobile'];
        } else {
            $content['email']  = NULL;
            $content['mobile'] = NULL;
        }
        echo json_encode($content);
    }
}