<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Set default controller and method
$routes->setDefaultController('Login');
$routes->setDefaultMethod('user_login');

$routes->setTranslateURIDashes(true);

$routes->get('/', 'Login::index');
$routes->get('login', 'Login::user_login');
$routes->post('login/validate_login', 'Login::validate_login');
$routes->get('logout', 'Login::logout');
$routes->get('admin/dashboard', 'Admin::dashboard');
$routes->get('leads/add_lead', 'Leads::add_lead');
$routes->post('leads/process_add_lead', 'Leads::process_add_lead');
$routes->get('leads/add_lead_success', 'Leads::add_lead_success');
$routes->get('leads/view_leads', 'Leads::view_leads');
$routes->get('leads/lead_details/(:num)', 'Leads::lead_details/$1');
$routes->get('leads/edit_lead/(:num)', 'Leads::edit_lead/$1');
$routes->post('leads/process_edit_lead/(:num)', 'Leads::process_edit_lead/$1');
$routes->get('leads/lead_details/(:num)', 'Leads::lead_details/$1');
$routes->get('leads/delete_lead/(:num)', 'Leads::delete_lead/$1');
$routes->get('leads/leadactivity', 'Leads::leadactivity');
$routes->get('leads/activity', 'Leads::activity');
$routes->post('leads/add_activity', 'Leads::add_activity');
$routes->get('leads/task', 'Leads::task');
$routes->post('leads/atask', 'Leads::atask');
$routes->get('leads/sales', 'Leads::sales');
$routes->post('leads/sales_activity', 'Leads::sales_activity');
$routes->get('leads/manage_leads', 'Leads::manage_leads');
$routes->post('leads/assign_lead', 'Leads::assign_lead');
$routes->get('leads/upload_leads', 'Leads::upload_leads');
$routes->post('leads/upload_leads', 'Leads::upload_leads');
$routes->get('admin/add_course', 'Admin::add_course');
$routes->post('admin/process_add_course', 'Admin::process_add_course');
$routes->get('admin/view_courses', 'Admin::view_courses');
$routes->get('admin/edit_course/(:num)', 'Admin::edit_course/$1');
$routes->post('admin/process_edit_course/(:num)', 'Admin::process_edit_course/$1');
$routes->get('admin/delete_course/(:num)', 'Admin::delete_course/$1');
$routes->get('admin/view_centers', 'Admin::view_centers');
$routes->get('admin/add_center', 'Admin::add_center');
$routes->post('admin/process_add_center', 'Admin::process_add_center');
$routes->get('admin/edit_user/(:num)', 'Admin::edit_user/$1');
$routes->post('admin/process_edit_center/(:num)', 'Admin::process_edit_center/$1');
$routes->get('admin/delete_user/(:num)', 'Admin::delete_user/$1');
$routes->get('reports/activity-report', 'Reports::activity_report');
$routes->get('reports/sales-report', 'Reports::sales_report');
$routes->get('reports/conversion-report', 'Reports::conversion_report');
$routes->get('reports/lead-source-report', 'Reports::lead_source_report');
$routes->get('reports/lead-summary', 'Reports::lead_summary');

$routes->get('terms-and-conditions', 'Login::terms');
$routes->get('refund-and-cancellation', 'Login::refund');
$routes->get('our-courses', 'Login::our_courses');
$routes->get('why-blackboard-education', 'Login::why_blackboard');
$routes->get('pay-online', 'Login::payment');
$routes->post('admin/get_city_by_state', 'Admin::get_city_by_state');